/*
 * Copyright (C) 2002 Bartosz Lis <bartoszl@ics.p.lodz.pl>
 * This is the main module
 */

#define _GNU_SOURCE

#include "config.h"

#include <stdlib.h>
#include <string.h>

#include "cfg_file.h"

char parser_error[256]="";
textrope_t **parser_examine=0;

cfg_field_t *
cfg_field_new(textrope_t *tr_left, textrope_t *tr_right, int status)
{
  cfg_field_t *cfnew;
  if (cfnew=(cfg_field_t *)malloc(sizeof(cfg_field_t)))
  {
    cfnew->next=0;
    cfnew->status=status;
    cfnew->lvalue=textrope_dup(tr_left);
    cfnew->rvalue=textrope_dup(tr_right);
    if (!cfnew->lvalue || !cfnew->rvalue) cfg_field_destroy(&cfnew);
  }
  return cfnew;
}

void
cfg_field_destroy(cfg_field_t **cf)
{
  cfg_field_t *cfdel;
  if (cf) while (*cf)
  {
    cfdel=*cf;
    *cf=(*cf)->next;
    if (cfdel->lvalue)
    {
      bzero(cfdel->lvalue,strlen(cfdel->lvalue));
      free(cfdel->lvalue);
    }
    if (cfdel->rvalue)
    {
      bzero(cfdel->rvalue,strlen(cfdel->rvalue));
      free(cfdel->rvalue);
    }
    free(cfdel);
  }
}

cfg_field_t *
cfg_field_join(cfg_field_t **cf1, cfg_field_t **cf2)
{
  cfg_field_t **cfbase, *cftail;
  if (!cf2 || !*cf2) return cf1 ? *cf1 : 0;
  cftail=*cf2;
  *cf2=0;
  if (!cf1) return cftail;
  cfbase=cf1;
  while (*cfbase) cfbase=&((*cfbase)->next);
  *cfbase=cftail;
  return *cf1;
}

