#include "config.h"

#include <stdio.h>
#include <unistd.h>
#include <termio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <string.h>

#define BUFF_SIZE   1024
#define STRLEN(str) (sizeof(str)-1)

void 
print_bar(void)
{
  printf("\n--------\n\n");
}

int
print_file(const char *fpath)
{
  FILE       *msg=0;
  const char *fname;
  if (fname=strrchr(fpath,'/')) ++fname; else fname=fpath;
  if (strncmp(fname,FNAME_PREFIX,STRLEN(FNAME_PREFIX)))
    printf("Inadequate name for issue file: '%s'\n",fpath);
  else if (msg=fopen(fpath,"r"))
  {
    static char buff[BUFF_SIZE];
    size_t len;
    while (len=fread(buff,sizeof(char),BUFF_SIZE,msg)) 
      fwrite(buff,sizeof(char),len,stdout);
    fclose(msg);
  }
  else
    printf("Cannot open file with message: '%s'\n",fpath);
  print_bar();
  return msg!=0;
}

int 
termsetraw(int desc, struct termio *ptbuf)
{
  struct termio tbuf;
  if (ioctl(desc,TCGETA,&tbuf)<0) return -1;
  if (ptbuf) *ptbuf=tbuf;
  tbuf.c_iflag&=~(INLCR|ICRNL|IUCLC|ISTRIP|IXON|BRKINT);
  tbuf.c_lflag&=~(ICANON|ISIG|ECHO);
  tbuf.c_cc[VTIME]=1;
  tbuf.c_cc[VMIN]=1;
  return ioctl(desc,TCSETAF,&tbuf);
}

int 
termreset(int desc, struct termio *ptbuf)
{
  return ioctl(desc,TCSETAF,ptbuf);
}

int 
main(int argc, char **argv)
{
  char          c, *home_dir;
  struct termio tbuf;
  int           i, n=0;
  home_dir=getenv("HOME");
  if (!home_dir || !*home_dir) home_dir="/";
  if (chdir(home_dir)) chdir("/");
  print_bar();
  for (i=1; i<argc; ++i) n+=print_file(argv[i]);
  if (!n) print_file(STD_ISSUE_FILE);
  printf("--- press any key to disconnect ---\n");
  fflush(0);
  termsetraw(0,&tbuf);
  read(0,&c,1);
  termreset(0,&tbuf);
  return 0;
}
